#include "explode.h"
#include "global.h"


explosion::explosion(float X, float Y, bool COL, bool massive)
{
	x = X;
	y = Y;
	col = COL;
	r = 0.0f;
	clear = false;
	big = massive;
}

void explosion::draw(BITMAP *to)
{
	if(clear)
		return;
	
	if(!col)
	{
		circlefill(to, (int)x, (int)y, (int)r, makecol(255, 255, 255));
		circle(to, (int)x, (int)y, (int)(r * 1.5f), makecol(0, 0, 0));
	}
	else
	{
		circlefill(to, (int)x, (int)y, (int)r, makecol(0, 0, 0));
		circle(to, (int)x, (int)y, (int)(r * 1.5f), makecol(255, 255, 255));
	}
}


void explosion::update()
{
	r += timeAdjuster * 0.1f;
	if(!big)
	{
		if(r > 3.0f)
			if((rand() % 10 < 5)||(r > 12.0f))
				clear = true;
	}
	else
	{
		if(r > 6.0f)
			if((rand() % 10 < 5)||(r > 24.0f))
				clear = true;
	}
	
}

